<?php
// admin/sidebar.php

// Extra security (optional but recommended)
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}

// Get current page for active menu
$currentPage = basename($_SERVER['PHP_SELF']);
?>

<!-- Sidebar -->
<aside class="admin-sidebar">
    <ul class="sidebar-menu">

        <li class="<?php echo ($currentPage == 'dashboard.php') ? 'active' : ''; ?>">
            <a href="dashboard.php">Dashboard</a>
        </li>

        <li class="<?php echo ($currentPage == 'users.php') ? 'active' : ''; ?>">
            <a href="users.php">Users</a>
        </li>

        <li class="<?php echo ($currentPage == 'transactions.php') ? 'active' : ''; ?>">
            <a href="transactions.php">Transactions</a>
        </li>

        <li class="<?php echo ($currentPage == 'wallet.php') ? 'active' : ''; ?>">
            <a href="wallet.php">Wallet</a>
        </li>

        <li class="<?php echo ($currentPage == 'pricing.php') ? 'active' : ''; ?>">
            <a href="pricing.php">Pricing</a>
        </li>

        <li class="<?php echo ($currentPage == 'api_settings.php') ? 'active' : ''; ?>">
            <a href="api_settings.php">API Settings</a>
        </li>

        <li class="logout">
            <a href="logout.php">Logout</a>
        </li>

    </ul>
</aside>